/*
 * Decompiled with CFR 0.152.
 */
package com.recipe.client;

import com.mojang.datafixers.util.Either;
import com.recipe.client.ClientImageTooltipComponent;
import com.recipe.tooltip.ImageTooltipComponent;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.client.event.RegisterClientTooltipComponentFactoriesEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="recipe", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class TooltipHandler {
    private static final Map<String, String> ITEM_IMAGE_MAP = Map.ofEntries(Map.entry("rtdd:noodles_2", "noodles_2.png"), Map.entry("rtdd:noodlesoup_4", "noodlesoup_4.png"), Map.entry("rtdd:noodlesoup_3", "noodlesoup_3.png"), Map.entry("rtdd:noodlesoup_2", "noodlesoup_2.png"), Map.entry("rtdd:plate_32", "plate_32.png"), Map.entry("rtdd:bowlofriceegg", "bowlofriceegg.png"), Map.entry("rtdd:dumplingssoup", "dumplingssoup.png"), Map.entry("rtdd:plate_30a", "plate_30a.png"), Map.entry("rtdd:assortedramen", "assortedramen.png"), Map.entry("rtdd:yushengramen", "yushengramen.png"), Map.entry("rtdd:bowlofrice", "bowlofrice.png"), Map.entry("rtdd:egg_noodles", "egg_noodles.png"), Map.entry("rtdd:tonkotsu_ramen", "tonkotsu_ramen.png"), Map.entry("rtdd:vegetable_noodles", "vegetable_noodles.png"), Map.entry("rtdd:boiled_egg", "boiled_egg.png"), Map.entry("rtdd:braisednoodles", "braisednoodles.png"), Map.entry("rtdd:bowlaeggcodsoup", "bowlaeggcodsoup.png"), Map.entry("rtdd:bowlalambstew", "bowlalambstew.png"), Map.entry("rtdd:bowlabeefbonebroth", "bowlabeefbonebroth.png"), Map.entry("rtdd:bowlavegetablebeefsoup", "bowlavegetablebeefsoup.png"), Map.entry("rtdd:bowlavegetablesstew", "bowlavegetablesstew.png"), Map.entry("rtdd:bowlacarrotbeefsoup", "bowlacarrotbeefsoup.png"), Map.entry("rtdd:bowlacarrotribs", "bowlacarrotribs.png"), Map.entry("rtdd:bowlacarrotcodsoup", "bowlacarrotcodsoup.png"), Map.entry("rtdd:bowlavegetableleanbroth", "bowlavegetableleanbroth.png"), Map.entry("rtdd:browncarrotfishsoupsoup", "browncarrotfishsoupsoup.png"), Map.entry("rtdd:brown_norieggsoup", "brown_norieggsoup.png"), Map.entry("rtdd:brownlambsoupwithturnipssoup", "brownlambsoupwithturnipssoup.png"), Map.entry("rtdd:bowla_lambchopsoup", "bowla_lambchopsoup.png"), Map.entry("rtdd:bowlavegetablelambsoup", "bowlavegetablelambsoup.png"), Map.entry("rtdd:bowlofmushroomsoup", "bowlofmushroomsoup.png"), Map.entry("rtdd:plate_24", "plate_24.png"), Map.entry("rtdd:plate_23", "plate_23.png"), Map.entry("rtdd:plate_22", "plate_22.png"), Map.entry("rtdd:plate_20", "plate_20.png"), Map.entry("rtdd:plate_19", "plate_19.png"), Map.entry("rtdd:plate_18", "plate_18.png"), Map.entry("rtdd:plate_17", "plate_17.png"), Map.entry("rtdd:plate_16", "plate_16.png"), Map.entry("rtdd:plate_15", "plate_15.png"), Map.entry("rtdd:plate_13", "plate_13.png"), Map.entry("rtdd:plate_12", "plate_12.png"), Map.entry("rtdd:plate_11", "plate_11.png"), Map.entry("rtdd:plate_10", "plate_10.png"), Map.entry("rtdd:plate_9", "plate_9.png"), Map.entry("rtdd:plate_8", "plate_8.png"), Map.entry("rtdd:plate_7", "plate_7.png"), Map.entry("rtdd:plate_6", "plate_6.png"), Map.entry("rtdd:plate_5", "plate_5.png"), Map.entry("rtdd:plate_4", "plate_4.png"), Map.entry("rtdd:plate_3", "plate_3.png"), Map.entry("rtdd:plate_2", "plate_2.png"), Map.entry("rtdd:plate_1", "plate_1.png"), Map.entry("rtdd:salmonsushicubes", "salmonsushicubes.png"), Map.entry("rtdd:codsushicubes", "codsushicubes.png"), Map.entry("rtdd:sashimisushicubes", "sashimisushicubes.png"), Map.entry("rtdd:oilcan", "oilcan.png"), Map.entry("rtdd:burritos", "burritos.png"), Map.entry("rtdd:plate_26d", "plate_26d.png"), Map.entry("rtdd:plate_21", "plate_21.png"), Map.entry("rtdd:codburritos", "codburritos.png"), Map.entry("rtdd:riceballs", "riceballs.png"), Map.entry("rtdd:riceseeds", "riceseeds.png"), Map.entry("rtdd:shiitakemushroomskewers", "shiitakemushroomskewers.png"), Map.entry("rtdd:kebabs_2", "kebabs_2.png"), Map.entry("rtdd:kebabs", "kebabs.png"), Map.entry("rtdd:cabbageskewers", "cabbageskewers.png"), Map.entry("rtdd:shouroubao", "shouroubao.png"), Map.entry("rtdd:plate_29", "plate_29.png"), Map.entry("rtdd:plate_27", "plate_27.png"), Map.entry("rtdd:plate_33", "plate_33.png"), Map.entry("rtdd:crab", "crab.png"), Map.entry("rtdd:lobster", "lobster.png"), Map.entry("rtdd:beancurd", "beancurd.png"), Map.entry("rtdd:dought_7", "dought_7.png"), Map.entry("rtdd:noodles", "noodles.png"), Map.entry("rtdd:cream_0", "cream_0.png"), Map.entry("rtdd:brownvegetablefishsoup", "brownvegetablefishsoup.png"), Map.entry("rtdd:bowlatufufish", "bowlatufufish.png"), Map.entry("rtdd:mushroomnoodles", "mushroomnoodles.png"), Map.entry("rtdd:thedriedfish", "thedriedfish.png"), Map.entry("rtdd:cooked_dought", "cooked_dought.png"), Map.entry("rtdd:cookedpancake", "cookedpancake.png"), Map.entry("rtdd:scallion_pancake_0", "scallion_pancake_0.png"), Map.entry("rtdd:plate_25", "plate_25.png"), Map.entry("rtdd:bannock", "bannock.png"), Map.entry("rtdd:saucecake", "saucecake.png"), Map.entry("rtdd:scallion_pancake", "scallion_pancake.png"), Map.entry("rtdd:doujiang", "doujiang.png"), Map.entry("rtdd:melon_popsicle", "melon_popsicle.png"), Map.entry("rtdd:grape_popsicle", "grape_popsicle.png"), Map.entry("rtdd:peach_popsicle", "peach_popsicle.png"), Map.entry("rtdd:apple_popsicle", "apple_popsicle.png"), Map.entry("rtdd:orange_popsicle", "orange_popsicle.png"), Map.entry("rtdd:garlic", "garlic.png"), Map.entry("rtdd:vegetables", "vegetables.png"), Map.entry("rtdd:nigirisushifish_1", "nigirisushifish_1.png"), Map.entry("rtdd:nigirisushifishcod", "nigirisushifishcod.png"), Map.entry("rtdd:nigirisushifishsalmon_1", "nigirisushifishsalmon_1.png"), Map.entry("rtdd:melonicecream", "melonicecream.png"), Map.entry("rtdd:appleicecream", "appleicecream.png"), Map.entry("rtdd:grapeicecream", "grapeicecream.png"), Map.entry("rtdd:peach_icecream", "peach_icecream.png"), Map.entry("rtdd:orange_icecream", "orange_icecram.png"));

    public static void registerTooltipComponentFactory(RegisterClientTooltipComponentFactoriesEvent event) {
        event.register(ImageTooltipComponent.class, ClientImageTooltipComponent::new);
        System.out.println("[recipe] \u5df2\u6ce8\u518c tooltip component \u5de5\u5382\uff01");
    }

    @SubscribeEvent
    public static void onRenderTooltip(RenderTooltipEvent.GatherComponents event) {
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        ResourceLocation itemId = ForgeRegistries.ITEMS.getKey((Object)stack.m_41720_());
        if (itemId == null) {
            return;
        }
        String imageFile = ITEM_IMAGE_MAP.get(itemId.toString());
        if (imageFile == null) {
            return;
        }
        ResourceLocation imageLocation = new ResourceLocation("recipe", "textures/gui/" + imageFile);
        ImageTooltipComponent component = new ImageTooltipComponent(imageLocation);
        event.getTooltipElements().add(1, Either.right((Object)component));
    }
}

