/*
 * Decompiled with CFR 0.152.
 */
package com.recipe.config;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.fml.loading.FMLPaths;

public class FishingConfig {
    public static List<String> FISHING_LOOT = List.of("empty*4", "rtdd:crab*2", "rtdd:lobster*2", "rtdd:jewelrybox_0*2");
    private static final Path CONFIG_PATH = FMLPaths.CONFIGDIR.get().resolve("recipe-fishing.json");

    public static void load() {
        if (!Files.exists(CONFIG_PATH, new LinkOption[0])) {
            FishingConfig.saveDefault();
            return;
        }
        try (BufferedReader reader = Files.newBufferedReader(CONFIG_PATH);){
            JsonObject json = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            JsonArray lootArray = json.getAsJsonArray("fishing_loot");
            ArrayList<String> result = new ArrayList<String>();
            for (JsonElement el : lootArray) {
                if (!el.isJsonPrimitive() || !el.getAsJsonPrimitive().isString()) continue;
                result.add(el.getAsString());
            }
            FISHING_LOOT = result;
            System.out.println("[Recipe] \u914d\u7f6e\u52a0\u8f7d\u5b8c\u6210\uff0c\u5171 " + result.size() + " \u6761\u6218\u5229\u54c1\u3002");
        }
        catch (Exception e) {
            System.err.println("[Recipe] \u8bfb\u53d6\u914d\u7f6e\u5931\u8d25\uff0c\u4f7f\u7528\u9ed8\u8ba4\u503c\uff01");
            e.printStackTrace();
        }
    }

    private static void saveDefault() {
        JsonObject json = new JsonObject();
        JsonArray lootArray = new JsonArray();
        for (String entry : FISHING_LOOT) {
            lootArray.add(entry);
        }
        json.add("fishing_loot", (JsonElement)lootArray);
        try (BufferedWriter writer = Files.newBufferedWriter(CONFIG_PATH, new OpenOption[0]);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)json, (Appendable)writer);
            System.out.println("[Recipe] \u5df2\u751f\u6210\u9ed8\u8ba4\u914d\u7f6e\u6587\u4ef6\uff01");
        }
        catch (IOException e) {
            System.err.println("[Recipe] \u4fdd\u5b58\u9ed8\u8ba4\u914d\u7f6e\u5931\u8d25\uff01");
        }
    }
}

